<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="app" select="/page/content/app"/>
    <xsl:variable name="databaseId" select="/page/content/database-id"/>
    <xsl:variable name="readonly" select="/page/content/readonly"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/database-info/DatabaseInfoAdminPage-database.js"/>
        <script type="text/javascript" src="/z/r/database-info/common.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/database-info/DatabaseInfoAdminPage-database.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET">
                    <table border="0">
                        <tr>
                            <td>UID: </td>
                            <td><input name="uid"><xsl:attribute name="value" select="$uid"/></input></td>
                        </tr>
                        <tr>
                            <td>App: </td>
                            <td><input name="app"><xsl:attribute name="value" select="$app"/></input></td>
                        </tr>
                        <tr>
                            <td>Database Id: </td>
                            <td><input name="databaseId"><xsl:attribute name="value" select="$databaseId"/></input></td>
                            <td>
                                <button class="btn btn-primary" type="submit">Find</button>
                            </td>
                        </tr>
                    </table>
                </form>
                <hr/>
                <xsl:apply-templates select="user"/>
                <xsl:apply-templates select="database">
                    <xsl:with-param name="app" select="$app"/>
                </xsl:apply-templates>
                <hr/>
                <xsl:if test="not($readonly=true())">
                    <button class="btn btn-info" id="add-record-btn"
                            data-uid="{$uid}"
                            data-app="{$app}"
                            data-database-id="{$databaseId}"
                    >Add record</button>
                    <xsl:text> </xsl:text>
                    <button class="btn btn-info" id="apply-delta-btn"
                            data-uid="{$uid}"
                            data-app="{$app}"
                            data-database-id="{$databaseId}"
                    >Apply delta</button>
                </xsl:if>

                <xsl:apply-templates select="snapshot/collections/collection">
                    <xsl:sort select="collection-id"/>
                </xsl:apply-templates>
            </div>
        </div>
        <div id="confirm" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h3 id="dialog-label">
                            Are you sure?
                        </h3>
                    </div>
                    <div class="modal-body">

                    </div>
                    <div class="modal-footer">

                    </div>
                </div>
            </div>
        </div>
        <div id="add-to-database" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <form class="form-horizontal">
                            <div class="control-group">
                                <label class="control-label" for="fieldId">Collection id</label>
                                <div class="controls">
                                    <input type="text" name="collectionId" placeholder="field id"/>
                                </div>
                            </div>
                            <div class="control-group">
                                <label class="control-label" for="type">Record id</label>
                                <div class="controls">
                                    <input type="text" name="recordId" placeholder="field id"/>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary">Create record</button>
                        <button data-dismiss="modal" class="btn btn-info">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
        <div id="add-to-collection" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <h3>RecordId:</h3>
                        <input class="input-block-level" name="recordId" placeholder="record id"/>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary">Create record</button>
                        <button data-dismiss="modal" class="btn btn-info">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
        <div id="add-record-field" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <form class="form-horizontal">
                            <div class="control-group">
                                <label class="control-label" for="fieldId">Field id</label>
                                <div class="controls">
                                    <input type="text" name="fieldId" placeholder="field id"/>
                                </div>
                            </div>
                            <div class="control-group">
                                <label class="control-label" for="type">Type</label>
                                <div class="controls">
                                    <select name="type" id="choose-field-type">
                                        <option>string</option>
                                        <option>integer</option>
                                        <option>decimal</option>
                                        <option>boolean</option>
                                        <option>bytes</option>
                                        <option value="infinity">+inf</option>
                                        <option value="negative_infinity">-inf</option>
                                        <option>null</option>
                                        <option>nan</option>
                                        <option>timestamp</option>
                                        <option>list</option>
                                    </select>
                                </div>
                            </div>
                            <div class="control-group">
                                <label class="control-label" for="type">Value</label>
                                <div class="controls">
                                    <div id="field-value">
                                        <input name="value"/>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary">Set field</button>
                        <button data-dismiss="modal" class="btn btn-info">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
        <div id="apply-delta" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
        <!--<div>-->
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-body">
                        <textarea name="changes" class="input-block-level" rows="20"/>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary">Apply delta</button>
                        <button data-dismiss="modal" class="btn btn-info">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="collection">
        <section>
            <h3>
                Collection: <xsl:value-of select="collection-id"/>
                <small>
                    records: <xsl:value-of select="count(records/record)"/>
                    size: <xsl:value-of select="z:format-data-size(sum(records/record/size))"/>
                </small>
                <xsl:if test="not($readonly=true())">
                    <button class="add-to-collection btn btn-info btn-small"
                            data-uid="{$uid}"
                            data-app="{$app}"
                            data-database-id="{$databaseId}"
                            data-collection-id="{collection-id}">
                        Add
                    </button>
                </xsl:if>
            </h3>
            <table class="table table-striped table-condensed table-bordered">
                <tr>
                    <th>Id</th>
                    <th>Size</th>
                    <th>Rev</th>
                    <th>Data</th>
                </tr>
                <xsl:apply-templates select="records/record">
                    <xsl:sort select="record-id"/>
                </xsl:apply-templates>
            </table>
        </section>
    </xsl:template>

    <xsl:template match="record">
        <tr data-uid="{$uid}"
            data-app="{$app}"
            data-database-id="{$databaseId}"
            data-collection-id="{../../collection-id}"
            data-record-id="{record-id}">
            <td width="7%">
                <xsl:value-of select="record-id"/>
            </td>
            <td width="5%">
                <xsl:value-of select="z:format-data-size(size)"/>
            </td>
            <td width="5%">
                <xsl:value-of select="rev"/>
            </td>
            <td width="100%">
                <xsl:if test="not($readonly=true())">
                    <a class="delete-record btn btn-small btn-link">
                        ×
                    </a>
                    <a class="add-record-field btn btn-small btn-link">
                        Add field
                    </a>
                </xsl:if>
                <xsl:for-each select="data">
                    <xsl:sort select="key"/>
                    <div>
                        <span>
                            <xsl:if test="not($readonly=true())">
                                <a class="delete-field" data-field-id="{key}">
                                    ×
                                </a>
                            </xsl:if>
                            <b><xsl:value-of select="key"/></b>
                        </span>
                        :
                        <xsl:choose>
                            <xsl:when test="string-length(value/value) > 128">
                                <span class="long-field-abbreviated"><xsl:value-of select="substring(value/value, 0, 100)"/>
                                    <a class="show-long-value btn btn-tiny">...</a>
                                </span>
                                <div class="long-field-full"><xsl:value-of select="value/value"/></div>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="value/value"/>
                            </xsl:otherwise>
                        </xsl:choose>
                        (
                        <xsl:value-of select="value/type"/>
                        )
                    </div>
                </xsl:for-each>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
