<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="app" select="/page/req/query/param[@name='app']"/>
    <xsl:variable name="databaseId" select="/page/req/query/param[@name='databaseId']"/>
    <xsl:variable name="uid" select="/page/req/query/param[@name='uid']"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/database-info/DatabaseInfoAdminPage-database.js"/>
        <script type="text/javascript" src="/z/r/database-info/common.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/database-info/DatabaseInfoAdminPage-database.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="delta"/>
    </xsl:template>

    <xsl:template match="delta">
        <xsl:variable name="rev" select="number(rev)"/>
        <xsl:variable name="id" select="id"/>

        <div id="main-content">
            <div class="container">
                <h2>
                    Database: <a href = "/z/database-info?app={$app}&amp;databaseId={$databaseId}&amp;uid={$uid}"><xsl:value-of select="$databaseId"/></a>
                </h2>
                <h2>
                <table width = "100%">
                    <tr>
                        <td width="33%">
                            <xsl:if test="rev != 0">
                                <a href="{rev - 1}?app={$app}&amp;databaseId={$databaseId}&amp;uid={$uid}">Prev</a>
                            </xsl:if>
                        </td>
                        <td width="33%" align="center">
                            <b>Rev: <xsl:value-of select="$rev"/></b>
                            <xsl:if test="id">
                                <nobr>
                                (
                                    <xsl:value-of select="$id"/>
                                )
                                </nobr>
                            </xsl:if>
                        </td>
                        <td width="33%" align="right">
                            <a href="{rev + 1}?app={$app}&amp;databaseId={$databaseId}&amp;uid={$uid}">Next</a>
                        </td>
                    </tr>
                </table>
                </h2>
                <br/>
                <table class="table table-striped table-condensed table-bordered">
                    <xsl:apply-templates select="changes">
                        <xsl:sort select="collection-id"/>
                        <xsl:sort select="record-id"/>
                    </xsl:apply-templates>
                </table>
                <h3>
                    <a href="{rev}.json?app={$app}&amp;databaseId={$databaseId}&amp;uid={$uid}">
                        View JSON
                    </a>
                </h3>
            </div>
        </div>

    </xsl:template>

    <xsl:template match="changes">
        <tr>
            <xsl:choose>
                <xsl:when test="type='insert'">
                    <xsl:apply-templates select="." mode="insert"/>
                </xsl:when>
                <xsl:when test="type='delete'">
                    <xsl:apply-templates select="." mode="delete"/>
                </xsl:when>
                <xsl:when test="type='update'">
                    <xsl:apply-templates select="." mode="update"/>
                </xsl:when>
            </xsl:choose>
        </tr>
    </xsl:template>

    <xsl:template match="changes" mode="insert">
        <td width="15%">
            <h4>
                Create
            </h4>
        </td>
        <td>
            <h4>
                <xsl:value-of select="concat(collection-id, '.', record-id)"/>
            </h4>
        </td>
    </xsl:template>

    <xsl:template match="changes" mode="delete">
        <td width="15%">
            <h4>
                Delete
            </h4>
        </td>
        <td>
            <h4>
                <xsl:value-of select="concat(collection-id, '.', record-id)"/>
            </h4>
        </td>
    </xsl:template>

    <xsl:template match="changes" mode="update">
        <td width="15%">
            <h4>
                Update
            </h4>
        </td>
        <td>
            <h4>
                <xsl:value-of select="concat(collection-id, '.', record-id)"/>
            </h4>
            <xsl:apply-templates select="field-change">
                <xsl:sort select="key"/>
            </xsl:apply-templates>
        </td>
    </xsl:template>

    <xsl:template match="field-change">
        <b>
            <xsl:value-of select="type"/>:
        </b>
        <xsl:text> </xsl:text>
        <xsl:value-of select="key"/>
        <xsl:if test="type='put'">
            <xsl:text> = </xsl:text>
            <xsl:value-of select="value/value"/>
            (
            <xsl:value-of select="value/type"/>
            )
        </xsl:if>
        <br/>
    </xsl:template>

</xsl:stylesheet>
