$(document).ready(function() {
    $(".delete-record").click(function() {
        var $this = $(this);
        var tr = $this.closest("tr");

        var app = $this.data("client-app")
        var originalApp = $this.data("original-app")
        var databaseId = $this.data("database-id")

        var $confirm = $("#confirm");
        var body = $(".modal-body", $confirm);
        body.html('<h4>Remove exteral database ' + app + ':' + originalApp + '@' + databaseId + '?</h4>')

        var footer = $(".modal-footer", $confirm);
        footer.html('')

        var removeLink = $('<a class="btn btn-danger">Yes</a>')

        footer.html('')
        footer.append(removeLink)
        footer.append($('<a class="btn btn-primary" data-dismiss="modal">No</a>'))

        removeLink.click(function() {
            $.post(
                    "external-databases/remove-external-database.json",
                    {
                        databaseId: databaseId,
                        app: app,
                        originalApp: originalApp
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            $("#confirm").modal('hide');
                            tr.remove();
                        }
                    },
                    "json"
            )
        })

        $confirm.modal();
    })

});
