<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/database-info/ExternalDatabasesAdminPage-index.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/database-info/DatabaseInfoAdminPage-database.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="by-client-app">
                    <xsl:sort select="key"/>
                </xsl:apply-templates>
                <hr/>

                <h2> Add new </h2>
                <form class="form-horizontal" method="POST" action="external-databases/add-external-database">
                    <div class="control-group">
                        <label class="control-label">Client app</label>
                        <div class="controls">
                            <input type="text" name="app" placeholder="app"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Host app</label>
                        <div class="controls">
                            <input type="text" name="originalApp" placeholder="originalApp"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Database id</label>
                        <div class="controls">
                            <input type="text" name="databaseId" placeholder="databaseId"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="type">Access type</label>
                        <div class="controls">
                            <select name="accessType">
                                <option>read-only</option>
                                <option>read-write</option>
                            </select>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="description">Description</label>
                        <div class="controls">
                            <textarea name="description" cols="50" rows="5"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <div class="controls">
                            <button type="submit" class="btn">Add</button>
                        </div>
                    </div>
                    <div>

                    </div>
                </form>
            </div>
        </div>

        <div id="confirm" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="dialog-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h3 id="dialog-label">
                            Are you sure?
                        </h3>
                    </div>
                    <div class="modal-body">

                    </div>
                    <div class="modal-footer">

                    </div>
                </div>
            </div>
        </div>

    </xsl:template>

    <xsl:template match="by-client-app">
        <h3>
            App: <xsl:value-of select="key"/>
        </h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <th>Original app</th>
                <th>Database id</th>
                <th>Access type</th>
                <th>Description</th>
                <th>External id</th>
            </tr>
            <xsl:for-each select="value">
                <tr>
                    <td>
                        <xsl:apply-templates select="original-app"/>
                    </td>
                    <td>
                        <xsl:apply-templates select="database-id"/>
                    </td>
                    <td>
                        <xsl:apply-templates select="access-type"/>
                        <a class="delete-record"
                           data-client-app="{app}"
                           data-original-app="{original-app}"
                           data-database-id="{database-id}">
                            ×
                        </a>
                    </td>
                    <td>
                        <xsl:apply-templates select="description"/>
                    </td>
                    <td>
                        .ext.
                        <xsl:apply-templates select="original-app"/>
                        @
                        <xsl:apply-templates select="database-id"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>

</xsl:stylesheet>
