package ru.yandex.chemodan.app.dataapi.web.admin;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseAccessType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author tolmalev
 */
@ActionContainer
public class ExternalDatabasesAdminPage {

    private final ExternalDatabasesRegistry registry;

    public ExternalDatabasesAdminPage(ExternalDatabasesRegistry registry) {
        this.registry = registry;
    }

    @ZAction(defaultAction = true)
    @Path("/external-databases")
    public ExternalDatabasesList index() {
        return new ExternalDatabasesList(registry.list());
    }

    @Path(value = "/external-databases/add-external-database", methods = HttpMethod.POST)
    public EmptyContentPojo addExternalDatabase(
            @RequestParam("app")
            String app,
            @RequestParam("originalApp")
            String originalAppId,
            @RequestParam("databaseId")
            String databaseId,
            @RequestParam("accessType")
            DatabaseAccessType accessType,
            @RequestParam("description")
            Option<String> description)
    {
        registry.addExternalDatabase(app, originalAppId, databaseId, accessType, description);
        throw new ZRedirectException("/z/external-databases");
    }

    @Path(value = "/external-databases/remove-external-database", methods = HttpMethod.POST)
    public EmptyContentPojo removeExternalDatabase(
            @RequestParam("app")
            String app,
            @RequestParam("originalApp")
            String originalAppId,
            @RequestParam("databaseId")
            String databaseId)
    {
        registry.removeExternalDatabase(app, originalAppId, databaseId);
        return new EmptyContentPojo();
    }

    @Bendable
    @XmlRootElement(name = "content")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static final class ExternalDatabasesList {
        private
        final MapF<String, ListF<ExternalDatabasesRegistry.ExternalDatabasePojo>> byClientApp;

        public ExternalDatabasesList(ListF<ExternalDatabasesRegistry.ExternalDatabasePojo> list) {
            byClientApp = list.groupBy(pojo -> pojo.app);
        }
    }
}
