<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/type-settings/common.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="type-settings"/>
    </xsl:template>

    <!--<xsl:template match="/">-->
    <!--<xmp>-->
    <!--<xsl:copy-of select="*"/>-->
    <!--</xmp>-->
    <!--</xsl:template>-->

    <xsl:template match="type-settings">
        <div id="main-content">
            <div class="container">
                <form method="POST" action="/z/type-settings/save?old-type-name={encode-for-uri(type-name)}">
                    <table border="0">
                        <tr>
                            <td>typeName:</td>
                            <td>
                                <input type="text" class="form-control" name="type-name" value="{type-name}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>jsonSchema:</td>
                            <td>
                                <textarea name="json-schema" class="form-control" cols="100">
                                    <xsl:value-of select="json-schema"/>
                                </textarea>
                            </td>
                        </tr>

                        <tr>
                            <td>idPropertyName:</td>
                            <td>
                                <input type="text" class="form-control" name="id-property-name"
                                       value="{id-property-name}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>orderedId:</td>
                            <td>
                                <input type="checkbox" value="{ordered-id}" name="ordered-id"
                                       onchange="this.value=this.checked">
                                    <xsl:if test="ordered-id='true'">
                                        <xsl:attribute name="checked">checked</xsl:attribute>
                                    </xsl:if>
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>isAllowInsert:</td>
                            <td>
                                <input type="checkbox" value="{is-allow-insert}" name="is-allow-insert"
                                       onchange="this.value=this.checked">
                                    <xsl:if test="is-allow-insert='true'">
                                        <xsl:attribute name="checked">checked</xsl:attribute>
                                    </xsl:if>
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>isAllowSet:</td>
                            <td>
                                <input type="checkbox" value="{is-allow-set}" name="is-allow-set"
                                       onchange="this.value=this.checked">
                                    <xsl:if test="is-allow-set='true'">
                                        <xsl:attribute name="checked">checked</xsl:attribute>
                                    </xsl:if>
                                </input>
                            </td>
                        </tr>
                        <tr>
                            <td>isDryRun:</td>
                            <td>
                                <input type="checkbox" value="{is-dry-run}" name="is-dry-run"
                                       onchange="this.value=this.checked">
                                    <xsl:if test="is-dry-run='true'">
                                        <xsl:attribute name="checked">checked</xsl:attribute>
                                    </xsl:if>
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>allowedOrders:</td>
                            <td>
                                <textarea type="text" class="form-control" name="allowed-orders" cols="5">
                                    <xsl:for-each select="allowed-orders">
                                        <xsl:value-of select="text()"/>
                                        <xsl:text>&#xA;</xsl:text>
                                    </xsl:for-each>
                                </textarea>
                            </td>
                        </tr>

                        <tr>
                            <td>app:</td>
                            <td>
                                <input type="text" class="form-control" name="app" value="{type-location/app}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>databaseId:</td>
                            <td>
                                <input type="text" class="form-control" name="databaseId" value="{type-location/database-id}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>collectionId:</td>
                            <td>
                                <input type="text" class="form-control" name="collectionId" value="{type-location/collection-id}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>datePaths:</td>
                            <td>
                                <input type="text" class="form-control" name="datePaths" value="{deletion-settings/date-paths}">
                                </input>
                            </td>
                        </tr>

                        <tr>
                            <td>deletionInterval (ms):</td>
                            <td>
                                <input type="text" class="form-control" name="deletionIntervalMs" value="{deletion-settings/deletion-interval-ms}">
                                </input>
                            </td>
                        </tr>

                    </table>
                    <button type="submit" class="btn btn-success">Save</button>
                </form>

            </div>
        </div>

    </xsl:template>

</xsl:stylesheet>
