<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/type-settings/common.js"/>
        <script type="text/javascript" src="/z/r/type-settings/jquery.confirm.min.js"/>
        <script type="text/javascript">
            function removeTypeSettings(typeName) {
                $.confirm({
                    text: "Are you sure you want to delete type " +typeName+ " ?",
                    title: "Confirmation required",
                    confirm: function(button) {
                        $.ajax({ url: '/z/type-settings/delete?type-name=' + typeName, type: 'POST'}).done(function(){location.reload();})
                    },
                    cancel: function(button) {
                        // nothing to do
                    },
                    confirmButton: "Yes",
                    cancelButton: "No",
                    //post: true,
                    confirmButtonClass: "btn-danger",
                    cancelButtonClass: "btn-default",
                    dialogClass: "modal-dialog modal-lg" // Bootstrap classes for large modal
                });
            }
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <!--<xsl:template match="/">-->
    <!--<xmp>-->
    <!--<xsl:copy-of select="*"/>-->
    <!--</xmp>-->
    <!--</xsl:template>-->

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <table class="table table-striped table-condensed table-bordered">
                    <caption>Settings for generic types</caption>
                    <tr>
                        <th>Type Name</th>
                        <th>App</th>
                        <th>Database Id</th>
                        <th>Collection Id</th>
                        <th>Действия</th>
                    </tr>
                    <xsl:for-each select="elements/element">
                        <tr>
                            <td>
                                <xsl:apply-templates select="type-name"/>
                            </td>
                            <td>
                                <xsl:apply-templates select="type-location/app"/>
                            </td>
                            <td>
                                <xsl:apply-templates select="type-location/database-id"/>
                            </td>
                            <td>
                                <xsl:apply-templates select="type-location/collection-id"/>
                            </td>
                            <td>
                                <a href="/z/type-settings/edit?type-name={encode-for-uri(type-name)}">Редактировать</a>,
                                <a href="#" onclick="removeTypeSettings('{encode-for-uri(type-name)}');">Удалить</a>
                            </td>
                        </tr>

                    </xsl:for-each>

                </table>
                <hr/>

                <form class="form-inline" role="form" method="POST" action="/z/type-settings/create">
                    <div class="form-group">
                        <label for="type-name">New Type Name:</label>
                        <input class="form-control" name="type-name" id="type-name" type="text"/>
                    </div>
                    <input type="submit" class="btn btn-default" value="Add"/>
                </form>

            </div>
        </div>

    </xsl:template>


</xsl:stylesheet>
