<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>
    <xsl:import href="./common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET">
                    <table border="0">
                        <tr>
                            <td>UID: </td>
                            <td><input name="uid"><xsl:attribute name="value" select="$uid"/></input></td>
                            <td>
                                <button class="btn btn-primary" type="submit">Find</button>
                            </td>
                        </tr>
                    </table>
                </form>
                <xsl:apply-templates select="user"/>
                <xsl:if test="string-length($uid) > 0 and not(databases)">
                    <div class="alert alert-danger">
                        <h3>No databases found for user</h3>
                    </div>
                </xsl:if>
                <xsl:for-each select="databases">
                    <xsl:sort select="key"/>
                    <h2>
                        Application: <a href="?uid={$uid}&amp;app={key}"><xsl:value-of select="key"/></a>
                    </h2>
                    <xsl:apply-templates select="value">
                        <xsl:sort select="id"/>
                    </xsl:apply-templates>
                    <hr/>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="value">
        <h3>
            Database:
            <xsl:choose>
                <xsl:when test="../key='.global'">
                    <a href="database-info?uid={$uid}&amp;databaseId={id}"><xsl:value-of select="id"/></a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="dbId" select="if (contains(id, '@')) then substring-after(id, '@') else id"/>
                    <a href="database-info?uid={$uid}&amp;app={../key}&amp;databaseId={$dbId}"><xsl:value-of select="id"/></a>
                </xsl:otherwise>
            </xsl:choose>
        </h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <td width="10%">
                    rev
                </td>
                <td>
                    <xsl:value-of select="rev"/>
                </td>
            </tr>
            <tr>
                <td>
                    size
                </td>
                <td>
                    <xsl:value-of select="z:format-data-size(size)"/>
                </td>
            </tr>
            <tr>
                <td>
                    records
                </td>
                <td>
                    <xsl:value-of select="records-count"/>
                </td>
            </tr>
            <tr>
                <td>
                    created
                </td>
                <td>
                    <xsl:value-of select="z:format-date-time(created)"/>
                </td>
            </tr>
            <tr>
                <td>
                    modified
                </td>
                <td>
                    <xsl:value-of select="z:format-date-time(modified)"/>
                </td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>
