package ru.yandex.chemodan.app.dataapi.web.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseAppContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterOrAll;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.MetaUser;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
@ActionContainer
public class UserDatabasesAdminPage extends DataApiAdminPageBase {

    private final DiskDataSource dataApiManager;

    private final Option<AccessRoutines> accessRoutines;

    private UserDatabasesAdminPage(
            UserMetaManager userMetaManager, DiskDataSource dataApiManager, Option<AccessRoutines> accessRoutines)
    {
        super(userMetaManager);
        this.dataApiManager = dataApiManager;
        this.accessRoutines = accessRoutines;
    }

    public UserDatabasesAdminPage(UserMetaManager userMetaManager, DiskDataSource dataApiManager) {
        this(userMetaManager, dataApiManager, Option.empty());
    }

    public UserDatabasesAdminPage(
            UserMetaManager userMetaManager, DiskDataSource dataApiManager, AccessRoutines accessRoutines) {
        this(userMetaManager, dataApiManager, Option.of(accessRoutines));
    }


    @ZAction(defaultAction = true, file = "databases.xsl")
    @Path("/user-databases")
    public UserDatabasesPojo index(
            @RequestParam(value = "uid", required = false)
            String uid,
            @RequestParam(value = "app", required = false)
            String app,
            @SpecialParam HttpServletRequestX req)
    {
        uid = StringUtils.defaultIfEmpty(uid, "").trim();
        app = StringUtils.defaultIfEmpty(app, "").trim();
        Option<DatabaseContext> contextO = app.equals(".global")
                ? Option.of(DatabaseContext.global())
                : Option.ofNullable(StringUtils.trimToNull(app)).map(DatabaseAppContext::new);

        if (StringUtils.isEmpty(uid)) {
            return new UserDatabasesPojo();
        }

        MetaUser user = getUser(uid);

        ListF<Database> databases = dataApiManager.listDatabases(
                user.getUserId(),
                contextO.map(DatabasesFilterSource::toDbsFilterOrAll)
                        .getOrElse(DatabasesFilterOrAll.all())
        );

        if (accessRoutines.isPresent()) {
            databases = accessRoutines.get().filterAccessibleByRequest(req, databases);
        }

        return new UserDatabasesPojo(uid, Option.of(user),
                databases.groupBy(Database.getAppOF().andThen(Option.getOrElseF(".global"))));
    }

    @Bendable
    @XmlRootElement(name = "content")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static final class UserDatabasesPojo {
        private final String uid;
        private final Option<MetaUser> user;
        private final MapF<String, ListF<Database>> databases;

        private UserDatabasesPojo() {
            this("", Option.empty(), Cf.map());
        }

        private UserDatabasesPojo(String uid, Option<MetaUser> user,
                MapF<String, ListF<Database>> databases)
        {
            this.uid = uid;
            this.user = user;
            this.databases = databases;
        }
    }
}
