getErrorDialog = function () {
    var dialog = $('#error-popup');
    if (dialog.length) {
        return dialog;
    }
    dialog = $('<div id="error-popup" class="modal fade" tabindex="-1" ' +
            ' role="dialog" aria-labelledby="dialog-label" aria-hidden="true">  ' +
            '<div class="modal-dialog"><div class="modal-content">' +
            ' <div class="modal-header">' +
            '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>' +
            '<h3 id="dialog-label"><span><t:_>Error</t:_></span></h3></div><div class="modal-body">' +
            '</div></div></div></div>');
    $('body').append(dialog);
    return dialog;
}

showAjaxErrorPopup = function (data, options) {
    if (data && data.name && data.message) {
        options = options || {};
        var popup = getErrorDialog();
        $('.modal-header span', popup).html(data.name);
        $('.modal-body', popup).html(data.message);
        $('.modal-footer', popup).toggle(options.showReloadPageHint === true);
        popup.modal({ backdrop: options.backdrop, keyboard: options.keyboard });
        return true;
    } else {
        return false;
    }
}

function resizeHeight(element) {
    $(element).css({'height': 'auto', 'overflow-y': 'hidden'}).height(element.scrollHeight);
}

$('textarea').each(function () {
    resizeHeight(this);
}).on('input', function () {
    resizeHeight(this);
});
