<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
        xmlns:z="urn:zscript-functions"
        exclude-result-prefixes="#all">

    <xsl:function name="z:format-data-size">
        <xsl:param name="bytes"/>
        <xsl:choose>
            <xsl:when test="$bytes >= 1024 * 1024 * 1024">
                <xsl:value-of select="concat($bytes idiv 1024 idiv 1024 idiv 1024, 'Gb')"/>
            </xsl:when>
            <xsl:when test="$bytes >= 1024 * 1024">
                <xsl:value-of select="concat($bytes idiv 1024 idiv 1024, 'Mb')"/>
            </xsl:when>
            <xsl:when test="$bytes >= 1024">
                <xsl:value-of select="concat($bytes idiv 1024, 'Kb')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$bytes"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:template match="user">
        <h3>User info</h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <td width="10%">
                    uid
                </td>
                <td>
                    <xsl:value-of select="uid"/>
                </td>
            </tr>
            <tr>
                <td>
                    login
                </td>
                <td>
                    <xsl:value-of select="login"/>
                </td>
            </tr>
            <tr>
                <td>
                    shardId
                </td>
                <td>
                    <xsl:value-of select="shard-id"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="database">
        <xsl:param name="app"/>
        <h3>
            Database:
            <xsl:choose>
                <xsl:when test="../key">
                    <xsl:choose>
                        <xsl:when test="$app = '.global'">
                            <a href="database-info?uid={$uid}&amp;databaseId={id}"><xsl:value-of select="id"/></a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="dbId" select="if (contains(id, '@')) then substring-after(id, '@') else id"/>
                            <a href="database-info?uid={$uid}&amp;app={$app}&amp;databaseId={$dbId}"><xsl:value-of select="id"/></a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="id"/>
                </xsl:otherwise>
            </xsl:choose>
        </h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <td width="10%">
                    rev
                </td>
                <td>
                    <xsl:value-of select="rev"/>
                    <xsl:if test="rev != '0'">
                        <xsl:text> </xsl:text>
                        <a href="database-info/delta/{number(rev) - 1}?uid={$uid}&amp;app={$app}&amp;databaseId={id}">View deltas</a>
                    </xsl:if>
                </td>
            </tr>
            <tr>
                <td>
                    size
                </td>
                <td>
                    <xsl:value-of select="z:format-data-size(size)"/>
                </td>
            </tr>
            <tr>
                <td>
                    records
                </td>
                <td>
                    <xsl:value-of select="records-count"/>
                </td>
            </tr>
            <tr>
                <td>
                    created
                </td>
                <td>
                    <xsl:value-of select="z:format-date-time(created)"/>
                </td>
            </tr>
            <tr>
                <td>
                    modified
                </td>
                <td>
                    <xsl:value-of select="z:format-date-time(created)"/>
                </td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>
