package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.parameter.WebRequest;

/**
 * @author vpronto
 */
public class FromAttributeInterceptor extends SetUserAndAppInfoByUidAndAppInterceptor {

    public static final String ATTR_KEY = "user-info";

    @Override
    protected Option<DataApiUserId> getUid(WebRequest request) {
        DataApiUserId userId = (DataApiUserId) request.getHttpServletRequest().getAttribute(ATTR_KEY);
        return Option.ofNullable(userId);
    }

    @Override
    protected Option<String> getApp(WebRequest request) {
        return request.getParameter("app").firstO();
    }

    @Override
    protected UserAndAppInfo.Source getSource() {
        return UserAndAppInfo.Source.QUERY_ARG;
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.SECURITY_INTERCEPTOR_ORDER;
    }
}
