package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.oauth.OAuthUtils;

/**
 * @author tolmalev
 */
public class FromOauthInterceptor extends SetUserAndAppInfoInterceptorBase {
    private final Blackbox2 blackbox;

    public FromOauthInterceptor(Blackbox2 blackbox) {
        this.blackbox = blackbox;
    }

    @Override
    protected Option<UserAndAppInfo> extractUserInfoO(WebRequest request) {
        return OAuthUtils.getOAuthUserInfo(blackbox, request.getHttpServletRequest())
                .map(oauthInfo -> new UserAndAppInfo(
                            Option.of(DataApiUserId.parse(oauthInfo.getUid().toString(), request)),
                            Option.of(oauthInfo.getOAuthInfo().getClientId()),
                            UserAndAppInfo.Source.OAUTH)
                );
    }

    @Override
    public int getOrder() {
        return 300;
    }
}
