package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.cloud.auth.PlatformUserDetails;
import ru.yandex.chemodan.cloud.auth.SecurityPlatformDispatcher;
import ru.yandex.chemodan.cloud.auth.config.PlatformClient;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.parameter.WebRequest;

/**
 * @author friendlyevil
 */
public class FromPlatformAttributeInterceptor extends SetUserAndAppInfoByUidAndAppInterceptor {

    @Override
    protected Option<DataApiUserId> getUid(WebRequest request) {
        return Option.ofNullable(request.getHttpServletRequest().getAttribute(SecurityPlatformDispatcher.UID_PARAMETER))
                .map(attr -> (ListF<String>) attr)
                .flatMapO(ListF::firstO)
                .map(DataApiUserId::parse);
    }

    @Override
    protected Option<String> getApp(WebRequest request) {
        return Option.ofNullable(request.getHttpServletRequest()
                .getAttribute(SecurityPlatformDispatcher.PLATFORM_ATTRIBUTE))
                .map(details -> (PlatformUserDetails) details)
                .map(PlatformUserDetails::getPlatformClient)
                .flatMapO(PlatformClient::getOauthClientId)
                .map(Object::toString);
    }

    @Override
    protected UserAndAppInfo.Source getSource() {
        return UserAndAppInfo.Source.PLATFORM;
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.SECURITY_INTERCEPTOR_ORDER;
    }
}
