package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class FromQueryParamsInterceptor extends SetUserAndAppInfoByUidAndAppInterceptor {

    private static final Logger log = LoggerFactory.getLogger(FromQueryParamsInterceptor.class);

    @Override
    protected Option<DataApiUserId> getUid(WebRequest request) {
        try {
            return getUidParamValue(request).map(uid -> DataApiUserId.parse(uid, request));
        } catch (Exception e) {
            log.info("failed to parse uid: " + e.getMessage());
            return Option.empty();
        }
    }

    @Override
    protected Option<String> getApp(WebRequest request) {
        return request.getParameter("app").firstO();
    }

    @Override
    protected UserAndAppInfo.Source getSource() {
        return UserAndAppInfo.Source.QUERY_ARG;
    }

    static Option<String> getUidParamValue(WebRequest request) {
        return request.getParameter("__uid").plus(request.getParameter("uid")).filterNot(String::isEmpty).firstO();
    }

    @Override
    public int getOrder() {
        return 100;
    }
}
