package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.parameter.WebRequest;

/**
 * @author friendlyevil
 */
public abstract class SetUserAndAppInfoByUidAndAppInterceptor extends SetUserAndAppInfoInterceptorBase{
    @Override
    protected Option<UserAndAppInfo> extractUserInfoO(WebRequest webRequest) {
        Option<DataApiUserId> uid = getUid(webRequest);
        Option<String> app = getApp(webRequest);
        if (uid.isPresent() || app.isPresent()) {
            return Option.of(new UserAndAppInfo(uid, app, getSource()));
        }

        return Option.empty();
    }

    protected abstract Option<DataApiUserId> getUid(WebRequest request);

    protected abstract Option<String> getApp(WebRequest request);

    protected abstract UserAndAppInfo.Source getSource();


    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.SECURITY_INTERCEPTOR_ORDER;
    }
}
