package ru.yandex.chemodan.app.dataapi.web.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public abstract class SetUserAndAppInfoInterceptorBase implements ActionDispatcherInterceptor {

    private static final String ATTR_KEY = "user-and-app-info";

    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) throws Exception {
        if (!hasInfo(invocationContext)) {
            extractUserInfoO(webRequest)
                    .forEach(info -> setInfo(webRequest, invocationContext, info));
        } else if (!hasUid(invocationContext)) {
            extractUserInfoO(webRequest)
                    .forEach(info -> {
                        info = getUserInfo(invocationContext).withUid(info.uid);
                        setInfo(webRequest, invocationContext, info);
                    });
        } else if (!hasApp(invocationContext)) {
            extractUserInfoO(webRequest)
                    .forEach(info -> {
                        info = getUserInfo(invocationContext).withApp(info.app);
                        setInfo(webRequest, invocationContext, info);
                    });
        }
    }

    private static void setInfo(WebRequest webRequest, ActionInvocationContext invocationContext, UserAndAppInfo info) {
        invocationContext.getInvocationAttributes().put(ATTR_KEY, info);
        HttpServletRequestX req = webRequest.getHttpServletRequest();

        info.uid.forEach(uid -> req.setAttribute(DiskLog4jRequestLog.UID_ATTRIBUTE, uid.serialize()));
        info.app.forEach(app -> req.setAttribute(DiskLog4jRequestLog.CLIENT_ID_ATTRIBUTE, app));
        req.setAttribute(DiskLog4jRequestLog.AUTH_SOURCE_ATTRIBUTE, info.source.name().toLowerCase());
    }

    protected abstract Option<UserAndAppInfo> extractUserInfoO(WebRequest webRequest);

    protected static boolean hasInfo(ActionInvocationContext invocationContext) {
        return invocationContext.getInvocationAttributes().get0(ATTR_KEY).isPresent();
    }

    protected static UserAndAppInfo getUserInfo(ActionInvocationContext invocationContext) {
        return invocationContext.getInvocationAttributes().get(ATTR_KEY);
    }

    protected static boolean hasUid(ActionInvocationContext invocationContext) {
        return getUserInfo(invocationContext).uid.isPresent();
    }

    protected static boolean hasApp(ActionInvocationContext invocationContext) {
        return getUserInfo(invocationContext).app.isPresent();
    }

    public static UserAndAppInfo getInfo(ActionInvocationContext invocationContext) {
        return (UserAndAppInfo) invocationContext
                .getInvocationAttributes()
                .get0(ATTR_KEY)
                .getOrElse(UserAndAppInfo.EMPTY);
    }
}
