package ru.yandex.chemodan.app.dataapi.web.auth;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        ProdBlackboxContextConfiguration.class
})
public class SetUserAndAppInterceptorsContextConfiguration {

    private final static Logger logger = LoggerFactory.getLogger(SetUserAndAppInterceptorsContextConfiguration.class);

    @Bean
    public FromAttributeInterceptor fromAttributeInterceptor() {
        return new FromAttributeInterceptor();
    }

    @Bean
    public FromQueryParamsInterceptor fromQueryParamsInterceptor() {
        return new FromQueryParamsInterceptor();
    }

    @Bean
    public FromPlatformAttributeInterceptor fromPlatformAttributeInterceptor() {
        return new FromPlatformAttributeInterceptor();
    }

    @Bean
    public SetUserAndAppInfoInterceptorBase fromOauthInterceptor(
            @Value("${oauth.enabled}") boolean enabled,
            Blackbox2 blackbox2) {
        if (enabled) {
            return new FromOauthInterceptor(blackbox2);
        } else {
            return new SetUserAndAppInfoInterceptorBase() {
                @Override
                protected Option<UserAndAppInfo> extractUserInfoO(WebRequest webRequest) {
                    return Option.empty();
                }

                @Override
                public int getOrder() {
                    return 10000;
                }
            };
        }
    }
}
