package ru.yandex.chemodan.app.dataapi.web.auth;

import lombok.With;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author tolmalev
 */
@With
public final class UserAndAppInfo {
    public static final UserAndAppInfo EMPTY = new UserAndAppInfo(Option.empty(), Option.empty(), Source.UNKNOWN);

    public final Option<DataApiUserId> uid;
    public final Option<String> app;
    public final Source source;

    public UserAndAppInfo(Option<DataApiUserId> uid, Option<String> app, Source source) {
        this.uid = uid;
        this.app = app;
        this.source = source;
    }

    public enum Source {
        QUERY_ARG,
        OAUTH,
        SESSION_ID,
        TVM,
        PLATFORM,
        UNKNOWN
    }
}
