package ru.yandex.chemodan.app.dataapi.web.batch;

import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@Value
public class BatchRequestItem {
    public final MapF<String, String> headers;
    public final String method;
    @BenderPart(name = "relativeUrl", strictName = true)
    public final String relativeUrl;
    public final Option<String> body; //body can be a string or json

    @BendingMethod
    public static BatchRequestItem parse(XmlOrJsonNode node) {

        String method = node.getJson().getField("method").get().getValueAsString();
        String relativeUrl = node.getJson().getField("relative_url").get().getValueAsString();
        Option<String> body = node.getJson().getField("body")
                .map(benderJsonNode -> benderJsonNode.isString() ? benderJsonNode.getValueAsString() : benderJsonNode.toString());
        MapF<String, String> headers = node.getJson().getField("headers")
                .map(benderJsonNode -> parseMap(benderJsonNode)).getOrElse(Cf.map());
        return new BatchRequestItem(headers, method, relativeUrl, body);
    }

    static MapF parseMap(BenderJsonNode node) {
        MapF result = Cf.hashMap();
        for (String fieldName : node.getFieldNames()) {
            BenderJsonNode valueNode = node.getField(fieldName).get();
                result.put(fieldName, valueNode.toString());
        }
        return result;
    }

    public String getNameSpace() {
        return StringUtils.substringBefore(getUrl(), "/");
    }

    public String getUrl() {
        return StringUtils.removeStart(relativeUrl, "/");
    }
}
