package ru.yandex.chemodan.app.dataapi.web.batch;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;

import ru.yandex.commune.a3.action.result.json.support.BaseJsonWriterRootAnyActionResult;
import ru.yandex.commune.json.write.JsonWriter2;

/**
 * @author Denis Bakharev
 */
@Data
public class BatchResult extends BaseJsonWriterRootAnyActionResult {

    private final List<OneInvocationJsonResult> invocationResults;

    public BatchResult(List<OneInvocationJsonResult> invocationResults) {
        this.invocationResults = invocationResults;
    }

    @Override
    public String getRootElement() {
        return "result";
    }

    @Override
    protected void write(JsonWriter2 jw) {
        jw.writeArrayStart();

        for(OneInvocationJsonResult invocationResult : invocationResults) {
            jw.writeObjectStart();

            jw.writeNumberField("code", invocationResult.statusCode);

            writeChildNodeIfExist("result", invocationResult.result, jw);
            writeChildNodeIfExist("error", invocationResult.result, jw);

            jw.writeObjectEnd();
        }

        jw.writeArrayEnd();
    }

    private void writeChildNodeIfExist(String childName, JsonNode rootNode, JsonWriter2 jw) {
        JsonNode childNode = rootNode.findPath(childName);
        if(!childNode.isMissingNode()) {
            jw.writeFieldName(childName);
            jw.writeRawValue(childNode.toString());
        }
    }
}
