package ru.yandex.chemodan.app.dataapi.web.binders;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.auth.SetUserAndAppInfoInterceptorBase;
import ru.yandex.chemodan.app.dataapi.web.auth.UserAndAppInfo;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;

public class DataApiOptionUserIdBinder implements ParameterBinder {

    @Nullable
    @Override
    public Option<DataApiUserId> createAndBind(WebRequest webRequest,
            ActionInvocationContext invocationContext, ParameterDescriptor parameterDescriptor)
    {
        UserAndAppInfo info = SetUserAndAppInfoInterceptorBase.getInfo(invocationContext);
        return info.uid;
    }
}
