package ru.yandex.chemodan.app.dataapi.web.direct;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

import static ru.yandex.chemodan.cloud.auth.SecurityPlatformDispatcher.PLATFORM_ATTRIBUTE;

/**
 * @author metal
 */
public class DirectActionInvocationUtils {
    public static boolean isDirectInvocation(ActionInvocationContext context) {
        return context.getRequest().getParameter("direct").containsTs("true")
                || isRestStyleInvocation(context.getRequest());
    }

    public static boolean isRestStyleInvocation(WebRequest request) {
        HttpServletRequestX requestX = request.getHttpServletRequest();
        return requestX.getRequestURI().startsWith("/v1/data/") ||
                requestX.getRequestURI().startsWith("/platform") ||
                requestX.getAttribute(PLATFORM_ATTRIBUTE) != null;
    }
}
