package ru.yandex.chemodan.app.dataapi.web.direct;

import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.bolts.function.Function2V;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.DataFieldJsonSerializers;
import ru.yandex.chemodan.app.dataapi.web.direct.unmarshallers.DataFieldJsonParsers;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum DirectDataFieldMapper {
    NULL("null", DataFieldJsonSerializers.writeTrueF, DataField::nul),
    BOOLEAN("boolean", DataFieldJsonSerializers::writeBoolean, DataFieldJsonParsers::parseBoolean),
    INTEGER("integer", DataFieldJsonSerializers::writeInteger, DataFieldJsonParsers::parseInteger),
    DECIMAL("double", DataFieldJsonSerializers::writeDecimal, DataFieldJsonParsers::parseDecimal),
    NAN("nan", DataFieldJsonSerializers.writeTrueF, DataField::nan),
    INFINITY("inf", DataFieldJsonSerializers.writeTrueF, DataField::infinity),
    NEGATIVE_INFINITY("ninf", DataFieldJsonSerializers.writeTrueF, DataField::negativeInfinity),
    STRING("string", DataFieldJsonSerializers::writeString, DataFieldJsonParsers::parseString),
    BYTES("binary", DataFieldJsonSerializers::writeBytes, DataFieldJsonParsers::parseBytes),
    TIMESTAMP("datetime", DataFieldJsonSerializers::writeTimestamp, DataFieldJsonParsers::parseTimestamp),
    DATETIME("datetime", DataFieldJsonSerializers::writeTimestamp, DataFieldJsonParsers::parseDateTime),
    LIST("list", DataFieldJsonSerializers::writeList, DataFieldJsonParsers::parseList),
    MAP("map", DataFieldJsonSerializers::writeMap, DataFieldJsonParsers::parseMap),
    ;

    public final String typeName;

    public final Function2V<BenderJsonWriter, DataField> marshallerF;

    public final Function<BenderJsonNode, DataField> unmarshallerF;

    DirectDataFieldMapper(String typeName,
            Function2V<BenderJsonWriter, DataField> marshallerF,
            Supplier<DataField> unmarshallerF)
    {
        this(typeName, marshallerF, ignore -> unmarshallerF.get());
    }

    DirectDataFieldMapper(String typeName,
            Function2V<BenderJsonWriter, DataField> marshallerF,
            Function<BenderJsonNode, DataField> unmarshallerF)
    {
        this.typeName = typeName;
        this.marshallerF = marshallerF;
        this.unmarshallerF = unmarshallerF;
    }

    public DataField parse(BenderJsonNode node) {
        return unmarshallerF.apply(node);
    }
}
