package ru.yandex.chemodan.app.dataapi.web.direct.a3;

import java.io.OutputStream;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

import static ru.yandex.chemodan.app.dataapi.web.direct.DirectActionInvocationUtils.isDirectInvocation;

/**
 * @author metal
 */
public class CompoundJsonPojoResultSerializer extends JsonPojoResultSerializer {

    private final BenderMapper directBenderMapper;

    public CompoundJsonPojoResultSerializer(BenderMapper generalBenderMapper, BenderMapper directBenderMapper) {
        super(generalBenderMapper);
        this.directBenderMapper = directBenderMapper;
    }

    @Override
    protected void serializeSafely(Object result, ActionInvocationContext context, OutputStream outputStream)
            throws Exception
    {
        if (isDirectInvocation(context)) {
            BenderJsonWriter json = BenderJsonWriter.json(outputStream);

            if (context.getRequest().getParameter("fields").isNotEmpty()) {
                json = FieldsFilteredBenderJsonWriter.consFromString(
                        context.getRequest().getParameter("fields").first(),
                        json
                );
            }

            directBenderMapper.serializeJsonAsSubclass(result, json, createContext(result, context));
        } else {
            super.serializeSafely(result, context, outputStream);
        }
    }
}
