package ru.yandex.chemodan.app.dataapi.web.direct.a3;

import java.io.OutputStream;

import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.web.direct.protobuf.ListDatabasesDirectPojo;
import ru.yandex.chemodan.app.dataapi.web.direct.protobuf.ListDeltasDirectResult;
import ru.yandex.chemodan.app.dataapi.web.direct.protobuf.SnapshotDirectPojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDatabasesPojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDeltasResult;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.ProtobufResultSerializer;
import ru.yandex.commune.a3.action.result.Variant;

import static ru.yandex.chemodan.app.dataapi.web.direct.DirectActionInvocationUtils.isDirectInvocation;

/**
 * @author metal
 */
public class CompoundProtobufResultSerializer extends ProtobufResultSerializer {
    @Override
    public void serialize(Object result, Variant variant, ActionInvocationContext context, OutputStream stream) {
        if (isDirectInvocation(context)) {
            if (result instanceof SnapshotPojo) {
                result = SnapshotDirectPojo.consFromSnapshotPojo((SnapshotPojo) result);
            } else if (result instanceof ListDeltasResult) {
                result = ListDeltasDirectResult.consFromListDeltasResult((ListDeltasResult) result);
            } else if (result instanceof ListDatabasesPojo) {
                result = ListDatabasesDirectPojo.consFromListDatabasesPojo((ListDatabasesPojo) result);
            }
        }

        super.serialize(result, variant, context, stream);
    }
}
