package ru.yandex.chemodan.app.dataapi.web.direct.a3;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.DataFieldJsonSerializers;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.DatabasePojoDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.DeltaDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.FieldChangeDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.ListDatabasesPojoDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.ListDeltasResultDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.ProtobufDataFieldDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.RecordChangeDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.SnapshotPojoMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.marshallers.SnapshotPojoRowDirectMarshaller;
import ru.yandex.chemodan.app.dataapi.web.direct.unmarshallers.DirectJsonUnmarshallers;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDatabasesPojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDeltasResult;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.DurationAsMillisMarshaller;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;

import static org.joda.time.format.ISODateTimeFormat.date;

/**
 * @author metal
 */
public class DirectDataApiBenderUtils {
    public static BenderMapper mapper() {
        return new BenderMapper(getConfig());
    }

    public static BenderConfiguration getConfig() {
        return new BenderConfiguration(new BenderSettings(),
                marshallerUnmarshallerFactory());
    }

    private static CustomMarshallerUnmarshallerFactory marshallerUnmarshallerFactory() {
        return marshallerUnmarshallerFactoryBuilder()
                .build();
    }

    public static CustomMarshallerUnmarshallerFactoryBuilder marshallerUnmarshallerFactoryBuilder() {
        DateTimeFormatter directDateTimeFormatter = directDateTimeFormatter();

        return CustomMarshallerUnmarshallerFactoryBuilder
                .cons()
                .add(Duration.class, new DurationAsMillisMarshaller())
                .add(Instant.class, new ReadableInstantConfigurableMarshaller(directDateTimeFormatter))
                .add(DateTime.class, new ReadableInstantConfigurableMarshaller(directDateTimeFormatter))
                .add(DataField.class, DataFieldJsonSerializers.consMarshaller())
                .add(ProtobufDataField.class, new ProtobufDataFieldDirectMarshaller())
                .add(RecordChange.class, new RecordChangeDirectMarshaller())
                .add(FieldChange.class, new FieldChangeDirectMarshaller())
                .add(SnapshotPojo.class,
                        new SnapshotPojoMarshaller(),
                        DirectJsonUnmarshallers.consSnapshotPojoUnmarshaller()
                )
                .add(SnapshotPojoRow.class, new SnapshotPojoRowDirectMarshaller())
                .add(DatabasePojo.class,
                        new DatabasePojoDirectMarshaller(),
                        DirectJsonUnmarshallers.consDatabasePojoUnmarshaller()
                )
                .add(ListDatabasesPojo.class, new ListDatabasesPojoDirectMarshaller())
                .add(Delta.class, new DeltaDirectMarshaller())
                .add(ListDeltasResult.class, new ListDeltasResultDirectMarshaller());
    }

    public static DateTimeFormatter directDateTimeFormatter() {
        return new DateTimeFormatterBuilder()
                .append(date())
                .appendLiteral('T')
                .appendHourOfDay(2)
                .appendLiteral(':')
                .appendMinuteOfHour(2)
                .appendLiteral(':')
                .appendSecondOfMinute(2)
                .appendLiteral('.')
                .appendFractionOfSecond(6, 6)
                .appendTimeZoneOffset("+00:00", true, 2, 2)
                .toFormatter();
    }
}
