package ru.yandex.chemodan.app.dataapi.web.direct.a3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.fasterxml.jackson.core.JsonFactory;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderJacksonUtils;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class FieldsFilteredBenderJsonWriterTest {

    static Entity entity = new Entity();
    static {
        entity.embedded1 = Option.of(new Entity());

        Entity embedded2 = new Entity();
        embedded2.embedded3 = Option.of(new Entity());
        entity.embedded2 = Option.of(embedded2);

        Entity embedded3 = new Entity();

        Entity embedded4 = new Entity();
        embedded4.ebmeddedList1 = Cf.list(new Entity());

        embedded3.ebmeddedList1 = Cf.list(embedded4, new Entity());
        entity.embedded3 = Option.of(embedded3);
    }

    @Test
    public void empty() throws IOException {
        Assert.equals("{}", serialize(""));
    }

    @Test
    public void strField() throws IOException {
        Assert.equals("{\"strField\":\"strValue\"}", serialize("strField"));
    }

    @Test
    public void embeddedField() throws IOException {
        Assert.equals("{" +
                    "\"embedded1\":{" +
                        "\"strField\":\"strValue\"," +
                        "\"intField\":100500," +
                        "\"boolField\":false," +
                        "\"ebmeddedList1\":[]," +
                        "\"ebmeddedList2\":[]" +
                    "}" +
                "}",
                serialize("embedded1")
        );
    }

    @Test
    public void complexEmbeddedField() throws IOException {
        Assert.equals(
                "{" +
                    "\"embedded2\":{" +
                        "\"strField\":\"strValue\"," +
                        "\"intField\":100500," +
                        "\"boolField\":false," +
                        "\"embedded3\":{" +
                            "\"strField\":\"strValue\"," +
                            "\"intField\":100500," +
                            "\"boolField\":false," +
                            "\"ebmeddedList1\":[]," +
                            "\"ebmeddedList2\":[]" +
                        "}," +
                        "\"ebmeddedList1\":[]," +
                        "\"ebmeddedList2\":[]" +
                    "}" +
                "}",
                serialize("embedded2")
        );
    }

    @Test
    public void complexEmbeddedFilteredField() throws IOException {
        Assert.equals(
                "{" +
                        "\"embedded2\":{" +
                            "\"strField\":\"strValue\"," +
                            "\"intField\":100500" +
                        "}" +
                "}",
                serialize("embedded2.strField,embedded2.intField")
        );
    }

    @Test
    public void complexEmbeddedAndNotFilteredField() throws IOException {
        Assert.equals(
                "{" +
                        "\"strField\":\"strValue\"," +
                        "\"embedded2\":{" +
                            "\"strField\":\"strValue\"," +
                            "\"intField\":100500" +
                        "}" +
                "}",
                serialize("strField,embedded2.strField,embedded2.intField")
        );
    }

    @Test
    public void embeddedList() throws IOException {
        Assert.equals(  "{" +
                            "\"ebmeddedList1\":[]" +
                        "}",
                serialize("ebmeddedList1")
        );

        Assert.equals(  "{" +
                            "\"embedded3\":{" +
                                "\"ebmeddedList1\":[" +
                                    "{" +
                                        "\"strField\":\"strValue\"," +
                                        "\"intField\":100500," +
                                        "\"boolField\":false," +
                                        "\"ebmeddedList1\":[" +
                                            "{" +
                                                "\"strField\":\"strValue\"," +
                                                "\"intField\":100500," +
                                                "\"boolField\":false," +
                                                "\"ebmeddedList1\":[]," +
                                                "\"ebmeddedList2\":[]" +
                                            "}" +
                                        "]," +
                                        "\"ebmeddedList2\":[]" +
                                    "}," +
                                    "{" +
                                        "\"strField\":\"strValue\"," +
                                        "\"intField\":100500," +
                                        "\"boolField\":false," +
                                        "\"ebmeddedList1\":[]," +
                                        "\"ebmeddedList2\":[]" +
                                    "}" +
                                "]" +
                            "}" +
                        "}",
                serialize("embedded3.ebmeddedList1")
        );
    }

    @Test
    public void embeddedListComplex() throws IOException {
        Assert.equals(  "{" +
                            "\"embedded3\":{" +
                                "\"ebmeddedList1\":[" +
                                    "{" +
                                        "\"strField\":\"strValue\"," +
                                        "\"boolField\":false" +
                                    "}," +
                                    "{" +
                                        "\"strField\":\"strValue\"," +
                                        "\"boolField\":false" +
                                    "}" +
                                "]" +
                            "}" +
                        "}",
                serialize("embedded3.ebmeddedList1.strField,embedded3.ebmeddedList1.boolField")
        );
    }

    @Test
    public void embeddedListComplex2() throws IOException {
        Assert.equals(
                "{\"" +
                    "embedded3\":{" +
                        "\"intField\":100500," +
                        "\"ebmeddedList1\":[" +
                            "{" +
                                "\"boolField\":false," +
                                "\"ebmeddedList1\":[" +
                                    "{" +
                                        "\"strField\":\"strValue\"" +
                                    "}" +
                                "]" +
                            "}," +
                            "{" +
                                "\"boolField\":false," +
                                "\"ebmeddedList1\":[]" +
                            "}" +
                        "]" +
                    "}" +
                "}",
                serialize("embedded3.ebmeddedList1.ebmeddedList1.strField,embedded3.ebmeddedList1.boolField,embedded3.intField")
        );
    }

    @Test
    public void allField() throws IOException {
//        FieldsFilteredBenderJsonWriter filter =
//                FieldsFilteredBenderJsonWriter.consFromString("strField,intField,boolField,embedded1,embedded2,embedded3");
//
//        String result = serialize(filter);
    }

    private String serialize(String fieldsStr) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BenderJsonWriter json = FieldsFilteredBenderJsonWriter.consFromString(fieldsStr, BenderJacksonUtils.wrap(new JsonFactory().createGenerator(baos)));
        Bender.jsonSerializer(Entity.class).serializeJson(entity, json);
        json.flush();

        return new String(baos.toByteArray());
    }

    @BenderBindAllFields
    static class Entity {
        String strField = "strValue";
        int intField = 100500;
        boolean boolField = false;

        Option<Entity> embedded1 = Option.empty();
        Option<Entity> embedded2 = Option.empty();
        Option<Entity> embedded3 = Option.empty();

        ListF<Entity> ebmeddedList1 = Cf.list();
        ListF<Entity> ebmeddedList2 = Cf.list();
    }
}
