package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function2V;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.web.direct.DirectDataFieldMapper;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.DirectDataApiBenderUtils;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.codec.FastBase64Coder;

/**
 * @author metal
 * @author Dmitriy Amelin (lemeh)
 */
public class DataFieldJsonSerializers {
    public static final String TYPE = "type";

    public static final Function2V<BenderJsonWriter, DataField> writeTrueF =
            (writer, fields) -> writer.writeBoolean(true);

    private static final ToFieldMarshaller timestampMarshaller =
            new ReadableInstantConfigurableMarshaller(DirectDataApiBenderUtils.directDateTimeFormatter());

    public static ToFieldMarshallerSupport consMarshaller() {
        return new ToFieldMarshallerSupport() {
            @Override
            public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
                writeJson(writer, fieldValue);
            }

            protected void writeJson(BenderJsonWriter json, Object o) {
                DataFieldJsonSerializers.writeJson(json, (DataField) o);
            }
        };
    }

    public static void writeJson(BenderJsonWriter json, DataField field) {
        DirectDataFieldMapper mapper = field.fieldType.directMapper;

        json.writeObjectStart();
        json.writeFieldName(TYPE);
        json.writeString(mapper.typeName);
        json.writeFieldName(mapper.typeName);

        mapper.marshallerF.apply(json, field);

        json.writeObjectEnd();
    }

    public static void writeBoolean(BenderJsonWriter json, DataField field) {
        json.writeBoolean((Boolean) field.value);
    }

    public static void writeInteger(BenderJsonWriter json, DataField field) {
        json.writeNumber(((Number) field.value).longValue());
    }

    public static void writeDecimal(BenderJsonWriter json, DataField field) {
        json.writeNumber(((Number) field.value).doubleValue());
    }

    public static void writeString(BenderJsonWriter json, DataField field) {
        json.writeString(field.value.toString());
    }

    public static void writeBytes(BenderJsonWriter json, DataField field) {
        json.writeString(new String(FastBase64Coder.encode((byte[]) field.value)));
    }

    public static void writeTimestamp(BenderJsonWriter json, DataField field) {
        timestampMarshaller.writeJsonToField(json, field.value, null);
    }

    public static void writeList(BenderJsonWriter json, DataField field) {
        json.writeArrayStart();
        @SuppressWarnings("unchecked")
        ListF<DataField> elements = (ListF<DataField>) field.value;
        for (DataField element : elements) {
            writeJson(json, element);
        }
        json.writeArrayEnd();
    }

    public static void writeMap(BenderJsonWriter json, DataField field) {
        json.writeObjectStart();
        @SuppressWarnings("unchecked")
        MapF<String, DataField> map = (MapF<String, DataField>) field.value;
        for (Tuple2<String, DataField> keyValue : map.entries()) {
            json.writeFieldName(keyValue.get1());
            writeJson(json, keyValue.get2());
        }
        json.writeObjectEnd();
    }

    private DataFieldJsonSerializers() {}
}
