package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.chemodan.app.dataapi.web.direct.a3.DirectDataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.bender.serialize.ToParentObjectMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author metal
 */
public class DatabasePojoDirectMarshaller extends ToFieldMarshallerSupport
        implements ToParentObjectMarshaller, ToFieldWithCallbackMarshaller
{
    private static final String RECORDS_COUNT = "records_count";
    private static final String CREATED = "created";
    private static final String MODIFIED = "modified";
    private static final String DATABASE_ID = "database_id";
    private static final String HANDLE = "handle";
    private static final String TITLE = "title";
    private static final String REVISION = "revision";
    private static final String SIZE = "size";

    private final ToFieldMarshaller timestampMarshaller =
            new ReadableInstantConfigurableMarshaller(DirectDataApiBenderUtils.directDateTimeFormatter());

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, fieldValue, new EmptyPojoMarshallingJsonCallback(), context);
    }


    @Override
    public void writeJsonToFieldWithCallback(
            BenderJsonWriter json, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        writeJson(json, fieldValue);
    }

    @Override
    public void writeXmlToParentObject(XmlWriter writer, Object o, PartPosition pp, MarshallerContext context) {
        throw new NotImplementedException("writeXmlToParentObject() is not implemented");
    }

    @Override
    public void writeXmlElementToParentObject(XmlWriter xmlWriter, Object o, PartPosition.Ordinary ordinary, MarshallerContext context) {
        throw new NotImplementedException("writeXmlToParentObject() is not implemented");
    }

    @Override
    public void writeJsonToParentArray(BenderJsonWriter json, Object o, MarshallerContext marshallerContext) {
        writeJson(json, o);
    }

    @Override
    public void writeJsonToParentObject(BenderJsonWriter writer, Object o, PartPosition.Ordinary ordinary,
                                        MarshallerContext context)
    {
        writeJsonToFieldWithCallback(writer, o, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeXmlToFieldWithCallback(
            XmlWriter writer, Object o, PojoMarshallingXmlCallback callback, MarshallerContext context)
    {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        DatabasePojo database = (DatabasePojo) o;

        json.writeObjectStart();

        json.writeFieldName(RECORDS_COUNT);
        json.writeNumber(database.recordsCount);

        json.writeFieldName(CREATED);
        timestampMarshaller.writeJsonToField(json, database.creationTime, null);

        json.writeFieldName(MODIFIED);
        timestampMarshaller.writeJsonToField(json, database.modificationTime, null);

        json.writeFieldName(DATABASE_ID);
        json.writeString(database.databaseId);

        json.writeFieldName(HANDLE);
        json.writeString(database.handle);

        if (database.description.isPresent()) {
            json.writeFieldName(TITLE);
            json.writeString(database.description.get());
        }

        json.writeFieldName(REVISION);
        json.writeNumber(database.rev);

        json.writeFieldName(SIZE);
        json.writeNumber(database.size);

        json.writeObjectEnd();
    }
}
