package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author metal
 */
public class DeltaDirectMarshaller extends ToFieldMarshallerSupport implements ToFieldWithCallbackMarshaller {
    private static final String BASE_REVISION = "base_revision";
    private static final String DELTA_ID = "delta_id";
    private static final String CHANGES = "changes";
    private static final String REVISION = "revision";

    private static final RecordChangeDirectMarshaller marshaller = new RecordChangeDirectMarshaller();

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        Delta delta = (Delta) o;

        json.writeObjectStart();

        if (delta.rev.isPresent()) {
            json.writeFieldName(BASE_REVISION);
            json.writeNumber(delta.rev.get());
        }

        if (delta.id.isPresent()) {
            json.writeFieldName(DELTA_ID);
            json.writeString(delta.id.get());
        }

        json.writeFieldName(CHANGES);
        json.writeArrayStart();
        for (RecordChange recordChange : delta.changes) {
            marshaller.writeJsonToField(json, recordChange, null);
        }
        json.writeArrayEnd();

        if (delta.newRev.isPresent()) {
            json.writeFieldName(REVISION);
            json.writeNumber(delta.newRev.get());
        }

        json.writeObjectEnd();
    }

    @Override
    public void writeJsonToFieldWithCallback(BenderJsonWriter json, Object o,
            PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        writeJson(json, o);
    }

    @Override
    public void writeXmlToFieldWithCallback(XmlWriter writer, Object fieldValue, PojoMarshallingXmlCallback callback,
            MarshallerContext context)
    {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }
}
