package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;

/**
 * @author metal
 */
public class FieldChangeDirectMarshaller extends ToFieldMarshallerSupport {
    private static final String FIELD = "field_id";
    private static final String CHANGE_TYPE = "change_type";
    private static final String VALUE = "value";
    private static final String LIST_INDEX = "list_item";
    private static final String LIST_MOVE_DEST_INDEX = "list_item_dest";

    private static final String PUT = "set";
    private static final String DELETE = "delete";
    private static final String SET_LIST_ITEM = "list_item_set";
    private static final String INSERT_LIST_ITEM = "list_item_insert";
    private static final String MOVE_LIST_ITEM = "list_item_move";
    private static final String DELETE_LIST_ITEM = "list_item_delete";

    private final ToFieldMarshallerSupport marshaller = new ToFieldMarshallerSupport() {
        @Override
        public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
            writeJson(writer, fieldValue);
        }

        protected void writeJson(BenderJsonWriter json, Object o) {
            DataFieldJsonSerializers.writeJson(json, (DataField) o);
        }
    };

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        FieldChange change = (FieldChange) o;

        json.writeObjectStart();
        json.writeFieldName(FIELD);
        json.writeString(change.key);

        if (change.type == FieldChange.FieldChangeType.PUT) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(PUT);

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.DELETE) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(DELETE);
        } else if (change.type == FieldChange.FieldChangeType.DELETE_LIST_ITEM) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(DELETE_LIST_ITEM);

            json.writeFieldName(LIST_INDEX);
            json.writeNumber(change.listIndex.get());
        } else if (change.type == FieldChange.FieldChangeType.PUT_LIST_ITEM) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(SET_LIST_ITEM);

            json.writeFieldName(LIST_INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.INSERT_LIST_ITEM) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(INSERT_LIST_ITEM);

            json.writeFieldName(LIST_INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(VALUE);
            marshaller.writeJsonToField(json, change.getValue(), null);
        } else if (change.type == FieldChange.FieldChangeType.MOVE_LIST_ITEM) {
            json.writeFieldName(CHANGE_TYPE);
            json.writeString(MOVE_LIST_ITEM);

            json.writeFieldName(LIST_INDEX);
            json.writeNumber(change.listIndex.get());

            json.writeFieldName(LIST_MOVE_DEST_INDEX);
            json.writeNumber(change.listMoveDestIndex.get());
        }
        json.writeObjectEnd();
    }
}
