package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDatabasesPojo;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.bender.serialize.ToParentObjectMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author metal
 */
public class ListDatabasesPojoDirectMarshaller extends ToFieldMarshallerSupport
        implements ToParentObjectMarshaller, ToFieldWithCallbackMarshaller
{
    private static final String ITEMS = "items";
    private static final String TOTAL = "total";
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";

    private final DatabasePojoDirectMarshaller marshaller = new DatabasePojoDirectMarshaller();

    @Override
    public void writeJsonToFieldWithCallback(
            BenderJsonWriter json, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        writeJson(json, fieldValue);
    }

    @Override
    public void writeXmlToParentObject(XmlWriter writer, Object o, PartPosition pp, MarshallerContext context) {
        throw new NotImplementedException("writeXmlToParentObject() is not implemented");
    }

    @Override
    public void writeJsonToParentArray(BenderJsonWriter writer, Object o, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, o, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeJsonToParentObject(BenderJsonWriter writer, Object o, PartPosition.Ordinary ordinary,
                                        MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, o, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeXmlToFieldWithCallback(
            XmlWriter writer, Object o, PojoMarshallingXmlCallback callback, MarshallerContext context)
    {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        ListDatabasesPojo databases = (ListDatabasesPojo) o;

        json.writeObjectStart();

        json.writeFieldName(ITEMS);
        json.writeArrayStart();
        for (DatabasePojo database : databases.databases) {
            marshaller.writeJsonToField(json, database, null);
        }
        json.writeArrayEnd();

        json.writeFieldName(TOTAL);
        json.writeNumber(databases.total);

        json.writeFieldName(LIMIT);
        json.writeNumber(databases.limit);

        json.writeFieldName(OFFSET);
        json.writeNumber(databases.offset);

        json.writeObjectEnd();
    }
}
