package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;

/**
 * @author metal
 */
public class ProtobufDataFieldDirectMarshaller extends ToFieldMarshallerSupport {
    private static final String FIELD_ID = "field_id";
    private static final String VALUE = "value";

    private final ToFieldMarshallerSupport dataFieldMarshaller = new ToFieldMarshallerSupport() {
        @Override
        public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
            writeJson(writer, fieldValue);
        }

        protected void writeJson(BenderJsonWriter json, Object o) {
            DataFieldJsonSerializers.writeJson(json, (DataField) o);
        }
    };

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        ProtobufDataField protobufDataField = (ProtobufDataField) o;

        json.writeObjectStart();

        json.writeFieldName(FIELD_ID);
        json.writeString(protobufDataField.fieldId);

        json.writeFieldName(VALUE);
        dataFieldMarshaller.writeJsonToField(json, protobufDataField.toDataField(), null);

        json.writeObjectEnd();
    }
}
