package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;

/**
 * @author metal
 */
public class RecordChangeDirectMarshaller extends ToFieldMarshallerSupport {
    private static final String CHANGE_TYPE = "change_type";
    private static final String COLLECTION_ID = "collection_id";
    private static final String RECORD_ID = "record_id";
    private static final String CHANGES = "changes";

    private static final FieldChangeDirectMarshaller fieldChangeMarshaller
            = new FieldChangeDirectMarshaller();

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        RecordChange recordChange = (RecordChange) o;

        json.writeObjectStart();

        json.writeFieldName(CHANGE_TYPE);
        json.writeString(recordChange.type.name().toLowerCase());

        json.writeFieldName(COLLECTION_ID);
        json.writeString(recordChange.collectionId);

        json.writeFieldName(RECORD_ID);
        json.writeString(recordChange.recordId);

        json.writeFieldName(CHANGES);
        json.writeArrayStart();
        for (FieldChange change : recordChange.fieldChanges) {
            fieldChangeMarshaller.writeJsonToField(json, change, null);
        }
        json.writeArrayEnd();

        json.writeObjectEnd();
    }
}
