package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.DirectDataApiBenderUtils;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.bender.serialize.ToParentObjectMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author metal
 */
public class SnapshotPojoMarshaller extends ToFieldMarshallerSupport
        implements ToParentObjectMarshaller, ToFieldWithCallbackMarshaller
{
    private static final String RECORDS_COUNT = "records_count";
    private static final String CREATED = "created";
    private static final String MODIFIED = "modified";
    private static final String RECORDS = "records";
    private static final String ITEMS = "items";
    private static final String TITLE = "title";
    private static final String DATABASE_ID = "database_id";
    private static final String HANDLE = "handle";
    private static final String REVISION = "revision";
    private static final String SIZE = "size";

    private final ToFieldMarshaller timestampMarshaller =
            new ReadableInstantConfigurableMarshaller(DirectDataApiBenderUtils.directDateTimeFormatter());

    private final SnapshotPojoRowDirectMarshaller snapshotPojoRowDirectMarshaller =
            new SnapshotPojoRowDirectMarshaller();

    @Override
    public void writeJsonToFieldWithCallback(
            BenderJsonWriter json, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        writeJson(json, fieldValue);
    }

    @Override
    public void writeXmlToParentObject(XmlWriter writer, Object o, PartPosition pp, MarshallerContext context) {
        throw new NotImplementedException("writeXmlToParentObject() is not implemented");
    }

    @Override
    public void writeJsonToParentArray(BenderJsonWriter writer, Object o, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, o, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeJsonToParentObject(BenderJsonWriter writer, Object o, PartPosition.Ordinary ordinary,
                                        MarshallerContext context)
    {
        writeJsonToFieldWithCallback(writer, o, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeXmlToFieldWithCallback(
            XmlWriter writer, Object o, PojoMarshallingXmlCallback callback, MarshallerContext context)
    {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        SnapshotPojo snapshot = (SnapshotPojo) o;

        json.writeObjectStart();

        json.writeFieldName(RECORDS_COUNT);
        json.writeNumber(snapshot.recordsCount);

        json.writeFieldName(CREATED);
        timestampMarshaller.writeJsonToField(json, snapshot.creationTime, null);

        json.writeFieldName(MODIFIED);
        timestampMarshaller.writeJsonToField(json, snapshot.modificationTime, null);

        json.writeFieldName(RECORDS);
        json.writeObjectStart();
        json.writeFieldName(ITEMS);
        json.writeArrayStart();
        for (SnapshotPojoRow snapshotRow : snapshot.objects) {
            snapshotPojoRowDirectMarshaller.writeJsonToField(json, snapshotRow, null);
        }
        json.writeArrayEnd();
        json.writeObjectEnd();

        if (snapshot.description.isPresent()) {
            json.writeFieldName(TITLE);
            json.writeString(snapshot.description.get());
        }

        json.writeFieldName(DATABASE_ID);
        json.writeString(snapshot.databaseId);

        json.writeFieldName(HANDLE);
        json.writeString(snapshot.handle);

        json.writeFieldName(REVISION);
        json.writeNumber(snapshot.rev);

        json.writeFieldName(SIZE);
        json.writeNumber(snapshot.size);

        json.writeObjectEnd();
    }
}
