package ru.yandex.chemodan.app.dataapi.web.direct.marshallers;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author metal
 */
public class SnapshotPojoRowDirectMarshaller extends ToFieldMarshallerSupport implements ToFieldWithCallbackMarshaller {
    private static final String RECORD_ID = "record_id";
    private static final String COLLECTION_ID = "collection_id";
    private static final String FIELDS = "fields";
    private static final String REVISION = "revision";

    private final ProtobufDataFieldDirectMarshaller protobufDataFieldMarshaller =
            new ProtobufDataFieldDirectMarshaller();

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJson(writer, fieldValue);
    }

    @Override
    public void writeJsonToFieldWithCallback(BenderJsonWriter json, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context) {
        writeJson(json, fieldValue);
    }

    @Override
    public void writeXmlToFieldWithCallback(XmlWriter writer, Object fieldValue, PojoMarshallingXmlCallback callback, MarshallerContext context) {
        throw new NotImplementedException("writeXmlToFieldWithCallback() is not implemented");
    }

    protected void writeJson(BenderJsonWriter json, Object o) {
        SnapshotPojoRow snapshotRow = (SnapshotPojoRow) o;

        json.writeObjectStart();

        json.writeFieldName(RECORD_ID);
        json.writeString(snapshotRow.recordId);

        json.writeFieldName(COLLECTION_ID);
        json.writeString(snapshotRow.collectionId);

        json.writeFieldName(FIELDS);
        json.writeArrayStart();
        for (ProtobufDataField field : snapshotRow.fields) {
            protobufDataFieldMarshaller.writeJsonToField(json, field, null);
        }
        json.writeArrayEnd();

        json.writeFieldName(REVISION);
        json.writeNumber(snapshotRow.rev);

        json.writeObjectEnd();
    }
}
