package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author metal
 */
@ProtoMessage
public class DirectDelta extends DefaultObject {
    @ProtoField(n = 1)
    public final ListF<DirectRecordChange> changes;
    @ProtoField(n = 2)
    public final Option<String> id;
    @ProtoField(n = 3)
    public final Option<Long> rev;
    @ProtoField(n = 4)
    public final Option<Long> newRev;

    public DirectDelta(ListF<RecordChange> changes, Option<String> id, Option<Long> rev, Option<Long> newRev) {
        this.changes = changes.map(DirectRecordChange::consFromRecordChange);
        this.id = id;
        this.rev = rev;
        this.newRev = newRev;
    }

    public static DirectDelta consFromDelta(Delta delta) {
        return new DirectDelta(delta.changes, delta.id, delta.rev, delta.newRev);
    }

    public Delta toDelta() {
        return new Delta(
                changes.map(DirectRecordChange::toRecordChange),
                id, rev, newRev
        );
    }
}
