package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange.FieldChangeType;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author metal
 */
@ProtoMessage
public class DirectFieldChange {
    @ProtoField(n = 1)
    public final FieldChangeType type;
    @ProtoField(n = 2)
    public final String key;
    @ProtoField(n = 3)
    public final Option<DirectProtobufDataFieldValue> value;
    @ProtoField(n = 4)
    public final Option<Integer> listIndex;
    @ProtoField(n = 5)
    public final Option<Integer> listMoveDestIndex;

    public DirectFieldChange(FieldChangeType type, String key, Option<DataField> value,
            Option<Integer> listIndex, Option<Integer> listMoveDestIndex)
    {
        this.type = type;
        this.key = key;
        this.value = value.map(DirectProtobufDataFieldValue::consFromDataField);
        this.listIndex = listIndex;
        this.listMoveDestIndex = listMoveDestIndex;
    }

    public static DirectFieldChange consFromFieldChange(FieldChange fieldChange) {
        Option<DataField> value;
        switch (fieldChange.type) {
            case PUT:
            case PUT_LIST_ITEM:
            case INSERT_LIST_ITEM:
                value = Option.of(fieldChange.getValue());
                break;
            default:
                value = Option.empty();
                break;
        }

        return new DirectFieldChange(fieldChange.type, fieldChange.key, value,
                fieldChange.listIndex, fieldChange.listMoveDestIndex);
    }

    public FieldChange toFieldChange() {
        switch (type) {
            case PUT: return FieldChange.put(key, value.map(DirectProtobufDataFieldValue::toDataField).get());
            case DELETE: return FieldChange.delete(key);
            case DELETE_LIST_ITEM: return FieldChange.deleteListItem(key, listIndex.get());
            case PUT_LIST_ITEM: return FieldChange.putListItem(key, listIndex.get(),
                    value.map(DirectProtobufDataFieldValue::toDataField).get());
            case MOVE_LIST_ITEM: return FieldChange.moveListItem(key, listIndex.get(),
                    listMoveDestIndex.get());
            case INSERT_LIST_ITEM: return FieldChange.insertListItem(key, listIndex.get(),
                    value.map(DirectProtobufDataFieldValue::toDataField).get());
            default: throw new RuntimeException("Unknown type " + type);
        }
    }
}
