package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author metal
 */
@ProtoMessage
public class DirectProtobufDataField extends DefaultObject {
    @ProtoField(n = 1)
    public final String fieldId;

    @ProtoField(n = 2)
    public final DirectProtobufDataFieldValue value;

    public DirectProtobufDataField(String fieldId, DataField dataField) {
        this.fieldId = fieldId;
        this.value = DirectProtobufDataFieldValue.consFromDataField(dataField);
    }

    public static DirectProtobufDataField consFromProtobufDataField(ProtobufDataField protobufDataField) {
        return new DirectProtobufDataField(protobufDataField.fieldId, protobufDataField.toDataField());
    }
}
