package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author metal
 */
@ProtoMessage
public class DirectProtobufDataFieldValue extends DefaultObject {
    @ProtoField(n = 1)
    private Option<Double> doubleValue = Option.empty();
    @ProtoField(n = 2)
    private Option<Long> integerValue = Option.empty();
    @ProtoField(n = 3)
    private Option<Boolean> booleanValue = Option.empty();
    @ProtoField(n = 4)
    private Option<String> stringValue = Option.empty();
    @ProtoField(n = 5)
    private Option<byte[]> binaryValue = Option.empty();
    @ProtoField(n = 6)
    private Option<Boolean> nullValue = Option.empty();
    @ProtoField(n = 7)
    private Option<Boolean> infinityValue = Option.empty();
    @ProtoField(n = 8)
    private Option<Boolean> negativeInfinityValue = Option.empty();
    @ProtoField(n = 9)
    private Option<Boolean> nanValue = Option.empty();
    @ProtoField(n = 10)
    private Option<Instant> datetimeValue = Option.empty();
    @ProtoField(n = 12)
    private ListF<DirectProtobufDataFieldValue> listValue = Cf.list();
    @ProtoField(n = 13)
    private DataFieldType type;

    public DirectProtobufDataFieldValue(DataFieldType type, Object value) {
        this.type = type;

        switch (type) {
            case DECIMAL: doubleValue = Option.of((Double) value); break;
            case INTEGER: integerValue = Option.of((Long) value); break;
            case BOOLEAN: booleanValue = Option.of((Boolean) value); break;
            case STRING: stringValue = Option.of((String) value); break;
            case BYTES: binaryValue = Option.of((byte[]) value); break;
            case NULL: nullValue = Option.of(true); break;
            case INFINITY: infinityValue = Option.of(true); break;
            case NEGATIVE_INFINITY: negativeInfinityValue = Option.of(true); break;
            case NAN: nanValue = Option.of(true); break;
            case TIMESTAMP: datetimeValue = Option.of((Instant) value); break;
            case LIST: {
                listValue = ((ListF<DataField>) value).map(DirectProtobufDataFieldValue::consFromDataField);
                break;
            }
            default:
                throw new RuntimeException("Can't serialize " + type);
        }
    }

    public static DirectProtobufDataFieldValue consFromDataField(DataField dataField) {
        return new DirectProtobufDataFieldValue(dataField.fieldType, dataField.value);
    }

    public DataField toDataField() {
        return new DataField(type, getValue());
    }

    private Object getValue() {
        switch (type) {
            case DECIMAL: return doubleValue.get();
            case INTEGER: return integerValue.get();
            case BOOLEAN: return booleanValue.get();
            case STRING: return stringValue.get();
            case BYTES: return binaryValue.get();
            case NULL: return null;
            case INFINITY: return Double.POSITIVE_INFINITY;
            case NEGATIVE_INFINITY: return Double.NEGATIVE_INFINITY;
            case NAN: return Double.NaN;
            case TIMESTAMP: return datetimeValue.get();
            case LIST: return listValue.map(DirectProtobufDataFieldValue::toDataField);
            default:
                throw new RuntimeException("Can't converts " + type);
        }
    }
}
