package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeType;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author metal
 */
@ProtoMessage
public class DirectRecordChange {
    @ProtoField(n = 1)
    public final RecordChangeType type;
    @ProtoField(n = 2)
    public final String collectionId;
    @ProtoField(n = 3)
    public final String recordId;
    @ProtoField(n = 4)
    public final ListF<DirectFieldChange> fieldChanges;

    public DirectRecordChange(RecordChangeType type, String collectionId, String recordId,
            ListF<FieldChange> fieldChanges)
    {
        this.type = type;
        this.collectionId = collectionId;
        this.recordId = recordId;
        this.fieldChanges = fieldChanges.map(DirectFieldChange::consFromFieldChange);
    }

    public static DirectRecordChange consFromRecordChange(RecordChange recordChange) {
        return new DirectRecordChange(recordChange.type, recordChange.collectionId,
                recordChange.recordId, recordChange.fieldChanges);
    }

    public RecordChange toRecordChange() {
        return new RecordChange(
                type,
                recordId,
                collectionId,
                fieldChanges.map(DirectFieldChange::toFieldChange)
        );
    }
}
