package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author metal
 */
@ActionResultPojo
@ProtoMessage
public class DirectSnapshotPojoRow extends DefaultObject {
    @ProtoField(n = 1)
    public final String collectionId;
    @ProtoField(n = 2)
    public final String recordId;
    @ProtoField(n = 3)
    public final long rev;
    @ProtoField(n = 4)
    public final ListF<DirectProtobufDataField> fields;

    public DirectSnapshotPojoRow(String collectionId, String recordId, long rev, ListF<ProtobufDataField> fields) {
        this.collectionId = collectionId;
        this.recordId = recordId;
        this.rev = rev;
        this.fields = fields.map(DirectProtobufDataField::consFromProtobufDataField);
    }

    public static DirectSnapshotPojoRow consFromSnapshotPojoRow(SnapshotPojoRow snapshotPojoRow) {
        return new DirectSnapshotPojoRow(
                snapshotPojoRow.collectionId, snapshotPojoRow.recordId, snapshotPojoRow.rev, snapshotPojoRow.fields);
    }
}
