package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDatabasesPojo;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author metal
 */
@ActionResultPojo
@ProtoMessage
public class ListDatabasesDirectPojo {
    @ProtoField(n = 1)
    public final ListF<DatabasePojo> items;

    @ProtoField(n = 2)
    public final int total;
    @ProtoField(n = 3)
    public final int limit;
    @ProtoField(n = 4)
    public final int offset;

    public ListDatabasesDirectPojo(ListF<DatabasePojo> items, int total, int limit, int offset) {
        this.items = items;
        this.total = total;
        this.limit = limit;
        this.offset = offset;
    }

    public static ListDatabasesDirectPojo consFromListDatabasesPojo(ListDatabasesPojo listDatabasesPojo) {
        return new ListDatabasesDirectPojo(listDatabasesPojo.databases,
                listDatabasesPojo.total, listDatabasesPojo.limit, listDatabasesPojo.offset);
    }
}
