package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDeltasResult;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author metal
 */
@ActionResultPojo
@ProtoMessage
public class ListDeltasDirectResult {
    @ProtoField(n = 1)
    public final long total;

    @ProtoField(n = 2)
    public final ListF<DirectDelta> items;

    @ProtoField(n = 3)
    public final int limit;

    @ProtoField(n = 4)
    public final long baseRevision;

    @ProtoField(n = 5)
    public final long revision;

    public ListDeltasDirectResult(long total, ListF<Delta> items, int limit, long baseRevision, long revision) {
        this.total = total;
        this.items = items.map(DirectDelta::consFromDelta);
        this.limit = limit;
        this.baseRevision = baseRevision;
        this.revision = revision;
    }

    public static ListDeltasDirectResult consFromListDeltasResult(ListDeltasResult listDeltasResult) {
        return new ListDeltasDirectResult(
                listDeltasResult.count,
                listDeltasResult.diffs,
                listDeltasResult.limit,
                listDeltasResult.currentDatabaseRev - listDeltasResult.count,
                listDeltasResult.currentDatabaseRev);
    }
}
