package ru.yandex.chemodan.app.dataapi.web.direct.protobuf;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author metal
 */
@ActionResultPojo
@ProtoMessage
public class SnapshotDirectPojo {
    @ProtoField(n = 1)
    public final long revision;

    @ProtoField(n = 2)
    public final long recordsCount;

    @ProtoField(n = 3)
    public final Instant created;

    @ProtoField(n = 4)
    public final Instant modified;

    @ProtoField(n = 5)
    public final long size;

    @ProtoField(n = 6)
    public final Option<String> title;

    @ProtoField(n = 7)
    public final SnapshotRecordsList records;

    @ProtoField(n = 8)
    public final String databaseId;

    @ProtoField(n = 9)
    public final String handle;

    public SnapshotDirectPojo(long revision, long recordsCount, Instant created, Instant modified, long size,
            Option<String> title, ListF<SnapshotPojoRow> records, String databaseId, String handle)
    {
        this.revision = revision;
        this.recordsCount = recordsCount;
        this.created = created;
        this.modified = modified;
        this.size = size;
        this.title = title;
        this.records = new SnapshotRecordsList(records);
        this.databaseId = databaseId;
        this.handle = handle;
    }

    public static SnapshotDirectPojo consFromSnapshotPojo(SnapshotPojo snapshotPojo) {
        return new SnapshotDirectPojo(snapshotPojo.rev, snapshotPojo.recordsCount,
                snapshotPojo.creationTime, snapshotPojo.modificationTime, snapshotPojo.size, snapshotPojo.description,
                snapshotPojo.objects, snapshotPojo.databaseId, snapshotPojo.handle);
    }
}
