package ru.yandex.chemodan.app.dataapi.web.direct.unmarshallers;

import org.joda.time.Instant;
import org.w3c.dom.Node;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.util.bender.ISOInstantUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DirectJsonUnmarshallers {
    public static FieldLevelUnmarshaller consSnapshotPojoUnmarshaller() {
        return new DirectUnmarshaller<>(DirectPojos.DirectSnapshot.class);
    }

    public static FieldLevelUnmarshaller consDatabasePojoUnmarshaller() {
        return new DirectUnmarshaller<>(DirectPojos.DirectDatabase.class);
    }

    private static class DirectUnmarshaller<C extends DirectPojos.DirectPojo<?>> implements FieldLevelUnmarshaller {
        private static final BenderMapper innerMapper = new BenderMapper(
                new BenderConfiguration(
                        new BenderSettings(),
                        CustomMarshallerUnmarshallerFactoryBuilder.cons()
                                .add(Instant.class, new ISOInstantUnmarshaller())
                                .add(DataField.class, DataFieldJsonParsers.consUnmarshaller())
                                .build()
                )
        );

        final Class<C> clientClass;

        private DirectUnmarshaller(Class<C> clientClass) {
            this.clientClass = clientClass;
        }

        private ParseResult<Object> parse(XmlOrJsonNode node, UnmarshallerContext context) {
            C clientObj = innerMapper.parse(clientClass, node, context);
            return ParseResult.result(clientObj.toPojo());
        }

        @Override
        public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext context) {
            return parse(XmlOrJsonNode.xml(node), context);
        }

        @Override
        public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
            return parse(XmlOrJsonNode.json(node), context);
        }
    }
}
