package ru.yandex.chemodan.app.dataapi.web.direct.unmarshallers;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataFieldSource;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DirectPojos {
    static abstract class DirectPojo<T> extends DefaultObject {
        abstract T toPojo();
    }

    @BenderBindAllFields
    static class DirectDatabase extends DirectPojo<DatabasePojo> {
        public final long revision;
        @BenderPart(name = "records_count", strictName = true)
        public final long recordsCount;
        public final Instant created;
        public final Instant modified;

        @BenderPart(name = "database_id", strictName = true)
        public final String databaseId;
        @BenderDefaultValue("")
        public final String handle;

        public final Option<String> title;
        public final long size;

        DirectDatabase(long revision, long recordsCount, Instant created, Instant modified,
                String databaseId, String handle, Option<String> title, long size)
        {
            this.revision = revision;
            this.recordsCount = recordsCount;
            this.created = created;
            this.modified = modified;
            this.databaseId = databaseId;
            this.title = title;
            this.size = size;
            this.handle = handle;
        }

        @Override
        DatabasePojo toPojo() {
            return new DatabasePojo(revision, recordsCount, created, modified, size, databaseId, title, handle);
        }

        private DatabaseMeta consMeta() {
            return toPojo().consMeta();
        }
    }

    @BenderBindAllFields
    static class DirectSnapshot extends DirectPojo<SnapshotPojo> {
        @BenderFlatten
        public final DirectDatabase database;

        @BenderPart(name = "records")
        public final DirectSnapshotRecords records;

        DirectSnapshot(DirectDatabase database, DirectSnapshotRecords records) {
            this.database = database;
            this.records = records;
        }

        @Override
        SnapshotPojo toPojo() {
            return new SnapshotPojo(database.revision, database.databaseId, database.handle, database.consMeta(),
                    records.toPojos());
        }

    }

    @BenderBindAllFields
    static class DirectSnapshotRecords {
        @BenderPart(name = "items")
        public final ListF<DirectSnapshotItem> items;

        DirectSnapshotRecords(ListF<DirectSnapshotItem> items) {
            this.items = items;
        }

        ListF<SnapshotPojoRow> toPojos() {
            return items.map(DirectSnapshotItem::toPojo);
        }
    }

    @Bendable
    public static class DirectSnapshotItem extends DirectPojo<SnapshotPojoRow> {
        @BenderPart(name = "revision")
        public final long revision;

        @BenderPart(name = "collection_id", strictName = true)
        public final String collectionId;

        @BenderPart(name = "record_id", strictName = true)
        public final String recordId;

        @BenderPart(name = "fields")
        public final ListF<DirectSnapshotField> fields;

        DirectSnapshotItem(long revision, String collectionId, String recordId, ListF<DirectSnapshotField> fields) {
            this.revision = revision;
            this.collectionId = collectionId;
            this.recordId = recordId;
            this.fields = fields;
        }

        @Override
        SnapshotPojoRow toPojo() {
            return new SnapshotPojoRow(collectionId, recordId, DataFields.fromFieldsSource(fields), revision);
        }
    }

    @Bendable
    public static class DirectSnapshotField implements NamedDataFieldSource {
        @BenderPart(name = "field_id", strictName = true)
        public final String fieldId;

        @BenderPart(name = "value")
        public final DataField value;

        DirectSnapshotField(String fieldId, DataField value) {
            this.fieldId = fieldId;
            this.value = value;
        }

        @Override
        public NamedDataField toNamedDataField() {
            return new NamedDataField(fieldId, value);
        }
    }
}
