package ru.yandex.chemodan.app.dataapi.web.direct.unmarshallers;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.DirectDataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.util.bender.ISOInstantUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DirectUnmarshallingTest {
    private static final BenderMapper mapper = DirectDataApiBenderUtils.mapper();

    private static final DataApiPassportUserId uid = new DataApiPassportUserId(1L);

    private static final AppDatabaseRef DB_REF = new AppDatabaseRef("app", "database_id");

    private static final String INSTANT_STR = "2016-06-12T19:29:26.964000+03:00";

    private static final Instant INSTANT = new ISOInstantUnmarshaller().convert(INSTANT_STR);

    public static final DatabaseHandle DB_HANDLE = DB_REF.consHandle("123456890");
    private static final Database DATABASE = new Database(uid, DB_HANDLE, 123L,
            new DatabaseMeta(INSTANT, INSTANT, DataSize.fromBytes(2048), 77));

    @Test
    public void database() {
        Assert.equals(DATABASE,
                mapper.parseJson(DatabasePojo.class, getDatabaseJson())
                        .toExistingDatabase(uid, DB_REF));
    }

    @Test
    public void snapshot() {
        Snapshot snapshot = new Snapshot(DATABASE, Cf.list(
                new DataRecord(uid, new DataRecordId(DB_HANDLE, "collectionId", "test_record"), 1L,
                        Cf.map("test_field", DataField.bool(false)))
        ));
        String json = getDatabaseJson("\"records\":{\"items\":[{"
                + "\"record_id\":\"test_record\","
                + "\"collection_id\":\"collectionId\","
                + "\"revision\":\"1\","
                + "\"fields\": [{"
                + "     \"field_id\":\"test_field\","
                + "     \"value\":{\"type\":\"boolean\", \"boolean\":false}"
                + "}]}]}");
        System.out.println(mapper.parseJson(SnapshotPojo.class, json));
        Assert.equals(snapshot,
                mapper.parseJson(SnapshotPojo.class, json)
                        .toDomainObject(uid, DB_REF)
        );
    }

    private String getDatabaseJson() {
        return getDatabaseJson(Option.empty());
    }

    private String getDatabaseJson(String suffix) {
        return getDatabaseJson(Option.of(suffix));
    }

    private String getDatabaseJson(Option<String> suffix) {
        return "{"
                + "\"records_count\":77,"
                + "\"created\":\"" + INSTANT_STR + "\","
                + "\"modified\":\"" + INSTANT_STR + "\","
                + "\"database_id\":\"database_id\","
                + "\"handle\":\"123456890\","
                + "\"revision\":123,"
                + "\"size\":2048"
                + suffix.map(s -> "," + s).getOrElse("")
                + "}";
    }
}
