package ru.yandex.chemodan.app.dataapi.web.generic;

import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "delete-generic-object", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Удалить объект по указаному идентификатору")
@Path(value = "/generic_data/{objectId}", methods = HttpMethod.DELETE)
public class DeleteGenericObjectAction extends GenericObjectActionBase {
    @PathParam
    private String objectId;

    public DeleteGenericObjectAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        super(genericObjectsApiHelper);
    }

    @Override
    public Object execute() throws Exception {
        return genericObjectsApiHelper.handleDelete(user, objectId, typeName);
    }
}
